package ga.core.selection;

import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IPopulation;

/**
 * Interface for an individual selector.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface ISelector<T extends IIndividual<T>> {
  /**
   * Selects individuals from the population.
   * 
   * @param population
   *          The population to select from.
   * @return The selected individuals.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public IndividualList<T> select(IPopulation<T> population);

  /**
   * Inserts individuals into the population.
   * 
   * @param list
   *          The individuals to insert.
   * @param population
   *          The population to insert to.
   * @param useEliteStrategy
   *          Use the elite strategy if <code>true</code>. That will prevent the
   *          elite from being replaced during insertion.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void insert(IndividualList<T> list, IPopulation<T> population,
      boolean useEliteStrategy);
}
